<?php
namespace App\Core;
class Auth {
  public static function check(){ Session::start(); return isset($_SESSION['user']); }
  public static function user(){ Session::start(); return $_SESSION['user'] ?? null; }

  public static function login($username, $password){
    Session::start();
    $pdo = DB::pdo();
    $ip = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
    $stmt = $pdo->prepare('SELECT COUNT(*) FROM login_attempts WHERE username=? AND attempted_at > DATE_SUB(NOW(), INTERVAL 15 MINUTE)');
    $stmt->execute([$username]); $count = (int)$stmt->fetchColumn();
    if($count >= 5){
      $pdo->prepare('INSERT INTO login_attempts (username, ip) VALUES (?,?)')->execute([$username, $ip]);
      return false;
    }
    $stmt = $pdo->prepare('SELECT * FROM users WHERE username=? LIMIT 1');
    $stmt->execute([$username]); $u = $stmt->fetch(\PDO::FETCH_ASSOC);
    if($u && password_verify($password, $u['password_hash'])){
      $pdo->prepare('DELETE FROM login_attempts WHERE username=?')->execute([$username]);
      unset($u['password_hash']);
      $_SESSION['user'] = $u;
      session_regenerate_id(true);
      return true;
    } else {
      $pdo->prepare('INSERT INTO login_attempts (username, ip) VALUES (?,?)')->execute([$username, $ip]);
      return false;
    }
  }

  public static function logout(){ Session::start(); session_unset(); session_destroy(); }
}
