<?php
namespace App\Middleware;
class CSRF {
  public static function token(){
    if(session_status() !== PHP_SESSION_ACTIVE) session_start();
    if(empty($_SESSION['csrf_token']) || ($_SESSION['csrf_token_exp'] ?? 0) < time()){
      $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
      $_SESSION['csrf_token_exp'] = time() + 3600;
    }
    return $_SESSION['csrf_token'];
  }
  public static function validate($token){
    if(session_status() !== PHP_SESSION_ACTIVE) session_start();
    if(empty($token) || empty($_SESSION['csrf_token'])) return false;
    return hash_equals($_SESSION['csrf_token'], $token);
  }
}
