<?php
namespace App\Services;
use App\Core\DB;
use PHPMailer\PHPMailer\PHPMailer;

class PasswordResetService {
  public static function createResetToken($userId){
    $token = bin2hex(random_bytes(32));
    $expires = date('Y-m-d H:i:s', time() + 7200);
    $stmt = DB::pdo()->prepare('INSERT INTO password_resets (user_id, token, expires_at) VALUES (?,?,?)');
    $stmt->execute([$userId, password_hash($token, PASSWORD_DEFAULT), $expires]);
    \App\Services\Audit::log($userId, 'password_reset_requested', 'user', $userId, null);
    return $token;
  }

  public static function verifyToken($token){
    $pdo = DB::pdo();
    $stmt = $pdo->prepare('SELECT * FROM password_resets WHERE used=0 AND expires_at > NOW()');
    $stmt->execute(); $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
    foreach($rows as $r){
      if(password_verify($token, $r['token'])) return $r;
    }
    return false;
  }

  public static function consumeToken($token, $newPassword){
    $pdo = DB::pdo();
    $row = self::verifyToken($token);
    if(!$row) return false;
    $pdo->prepare('UPDATE users SET password_hash=? WHERE id=?')->execute([password_hash($newPassword, PASSWORD_DEFAULT), $row['user_id']]);
    $pdo->prepare('UPDATE password_resets SET used=1 WHERE id=?')->execute([$row['id']]);
    \App\Services\Audit::log($row['user_id'], 'password_reset_completed', 'user', $row['user_id'], null);
    return true;
  }

  public static function sendResetEmail($userEmail, $token){
    $config = require __DIR__ . '/../../config.php';
    $mail = new PHPMailer(true);
    // Configure SMTP as needed - placeholder
    $mail->setFrom($config['mail']['from'], $config['mail']['from_name'] ?? 'ISP Billing');
    $mail->addAddress($userEmail);
    $url = rtrim($config['base_url'], '/') . '/public/password_reset.php?token=' . urlencode($token);
    $mail->isHTML(true);
    $mail->Subject = 'Password reset request';
    $mail->Body = "Click the link to reset your password: <a href='{$url}'>{$url}</a>";
    return $mail->send();
  }
}
