<?php
namespace App\Services;
use App\Core\DB;

class Payments {
  public static function createPayment($gateway, $amount, $account_type=null, $account_id=null, $meta=null){
    $stmt = DB::pdo()->prepare('INSERT INTO payments (gateway, amount, account_type, account_id, status, meta) VALUES (?,?,?,?,?,?)');
    $stmt->execute([$gateway, $amount, $account_type, $account_id, 'pending', json_encode($meta)]);
    return DB::pdo()->lastInsertId();
  }

  public static function handleGatewayWebhook($gateway, $payloadRaw, $headers = []){
    $pdo = DB::pdo();
    $pdo->prepare('INSERT INTO webhooks (gateway, payload, verified) VALUES (?,?,?)')->execute([$gateway, $payloadRaw, 0]);

    $config = require __DIR__ . '/../../config.php';
    $conf = $config['payments'][$gateway] ?? null;
    $verified = false;
    if($conf && !empty($conf['webhook_secret']) && !empty($conf['webhook_sig_header'])){
      $sigHeader = $conf['webhook_sig_header'];
      $algo = $conf['webhook_algo'] ?? 'sha256';
      $signature = $headers[$sigHeader] ?? ($_SERVER['HTTP_' . strtoupper(str_replace('-', '_', $sigHeader))] ?? null);
      if($signature){
        $computed = hash_hmac($algo, $payloadRaw, $conf['webhook_secret']);
        if(hash_equals($computed, $signature)) $verified = true;
      }
    }

    if($verified){
      $payload = json_decode($payloadRaw, true);
      if(!empty($payload['txid'])){
        $stmt = $pdo->prepare('SELECT * FROM payments WHERE txid=? LIMIT 1');
        $stmt->execute([$payload['txid']]);
        $p = $stmt->fetch(\PDO::FETCH_ASSOC);
        if($p){
          $pdo->prepare('UPDATE payments SET status=?, meta=? WHERE id=?')->execute(['completed', json_encode($payload), $p['id']]);
          \App\Services\Audit::log(null, 'payment_webhook_processed', 'payment', $p['id'], $payload);
        }
      }
    }

    $pdo->prepare('UPDATE webhooks SET verified=? WHERE id=(SELECT MAX(id) FROM webhooks)')->execute([$verified ? 1 : 0]);
    return $verified;
  }
}
