<?php
namespace App\Services;
use App\Core\DB;
use Dompdf\Dompdf;

class VoucherService {
  public static function generateVoucher($hotelId, $packageId, $durationMinutes, $createdBy=null){
    $code = strtoupper(substr(bin2hex(random_bytes(6)),0,12));
    $stmt = DB::pdo()->prepare('INSERT INTO vouchers (hotel_id, code, package_id, duration_minutes, created_by) VALUES (?,?,?,?,?)');
    $stmt->execute([$hotelId, $code, $packageId, $durationMinutes, $createdBy]);
    \App\Services\Audit::log($createdBy, 'voucher_generated', 'voucher', null, ['code'=>$code, 'hotel'=>$hotelId]);
    return $code;
  }

  public static function generateVoucherBatch($hotelId, $packageId, $count, $durationMinutes, $createdBy=null){
    $codes = [];
    for($i=0;$i<$count;$i++){
      $codes[] = self::generateVoucher($hotelId, $packageId, $durationMinutes, $createdBy);
    }
    return $codes;
  }

  public static function batchPdf(array $codes){
    $pdo = DB::pdo();
    $html = '<html><body style="font-family: Arial, sans-serif;">';
    foreach($codes as $code){
      $stmt = $pdo->prepare('SELECT v.*, u.full_name as hotel_name, u.logo_path FROM vouchers v LEFT JOIN users u ON u.id=v.hotel_id WHERE v.code=?');
      $stmt->execute([$code]); $v = $stmt->fetch(\PDO::FETCH_ASSOC);
      if(!$v) continue;
      if($v['logo_path']) $html .= "<div><img src='".htmlspecialchars($v['logo_path'])."' style='max-height:80px' /></div>";
      $html .= "<h2>Voucher: ".htmlspecialchars($v['code'])."</h2>";
      $html .= "<p>Hotel: ".htmlspecialchars($v['hotel_name'])."</p>";
      $html .= "<p>Duration: ".htmlspecialchars($v['duration_minutes'])." minutes</p>";
      $html .= "<p>Generated: ".htmlspecialchars($v['created_at'])."</p>";
      $html .= '<div style="page-break-after: always;"></div>';
    }
    $html .= '</body></html>';
    $dompdf = new Dompdf();
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4','portrait');
    $dompdf->render();
    return $dompdf->stream("vouchers_batch.pdf", ['Attachment'=>0]);
  }
}
